package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateVodSourceResponse(
    arn: Option[__string] = None,
    creationTime: Option[__timestampUnix] = None,
    httpPackageConfigurations: Option[
      Iterable[zio.aws.mediatailor.model.HttpPackageConfiguration]
    ] = None,
    lastModifiedTime: Option[__timestampUnix] = None,
    sourceLocationName: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    vodSourceName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse = {
    import CreateVodSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        httpPackageConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.httpPackageConfigurations)
      .optionallyWith(
        lastModifiedTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        sourceLocationName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sourceLocationName)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        vodSourceName.map(value => __string.unwrap(value): java.lang.String)
      )(_.vodSourceName)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly =
    zio.aws.mediatailor.model.CreateVodSourceResponse.wrap(buildAwsValue())
}
object CreateVodSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateVodSourceResponse =
      zio.aws.mediatailor.model.CreateVodSourceResponse(
        arn.map(value => value),
        creationTime.map(value => value),
        httpPackageConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastModifiedTime.map(value => value),
        sourceLocationName.map(value => value),
        tags.map(value => value),
        vodSourceName.map(value => value)
      )
    def arn: Option[__string]
    def creationTime: Option[__timestampUnix]
    def httpPackageConfigurations: Option[
      List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    ]
    def lastModifiedTime: Option[__timestampUnix]
    def sourceLocationName: Option[__string]
    def tags: Option[Map[__string, __string]]
    def vodSourceName: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getHttpPackageConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "httpPackageConfigurations",
      httpPackageConfigurations
    )
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse
  ) extends zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val creationTime: Option[__timestampUnix] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val httpPackageConfigurations: Option[
      List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    ] = scala
      .Option(impl.httpPackageConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }.toList
      )
    override val lastModifiedTime: Option[__timestampUnix] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val sourceLocationName: Option[__string] = scala
      .Option(impl.sourceLocationName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
    override val vodSourceName: Option[__string] = scala
      .Option(impl.vodSourceName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateVodSourceResponse
  ): zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
