package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePrefetchScheduleResponse(
    arn: Option[__string] = None,
    consumption: Option[zio.aws.mediatailor.model.PrefetchConsumption] = None,
    name: Option[__string] = None,
    playbackConfigurationName: Option[__string] = None,
    retrieval: Option[zio.aws.mediatailor.model.PrefetchRetrieval] = None,
    streamId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse = {
    import CreatePrefetchScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(consumption.map(value => value.buildAwsValue()))(
        _.consumption
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        playbackConfigurationName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.playbackConfigurationName)
      .optionallyWith(retrieval.map(value => value.buildAwsValue()))(
        _.retrieval
      )
      .optionallyWith(
        streamId.map(value => __string.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly =
    zio.aws.mediatailor.model.CreatePrefetchScheduleResponse
      .wrap(buildAwsValue())
}
object CreatePrefetchScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreatePrefetchScheduleResponse =
      zio.aws.mediatailor.model.CreatePrefetchScheduleResponse(
        arn.map(value => value),
        consumption.map(value => value.asEditable),
        name.map(value => value),
        playbackConfigurationName.map(value => value),
        retrieval.map(value => value.asEditable),
        streamId.map(value => value)
      )
    def arn: Option[__string]
    def consumption
        : Option[zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly]
    def name: Option[__string]
    def playbackConfigurationName: Option[__string]
    def retrieval: Option[zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly]
    def streamId: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getConsumption: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly
    ] = AwsError.unwrapOptionField("consumption", consumption)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPlaybackConfigurationName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("playbackConfigurationName", playbackConfigurationName)
    def getRetrieval: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly
    ] = AwsError.unwrapOptionField("retrieval", retrieval)
    def getStreamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse
  ) extends zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val consumption
        : Option[zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly] = scala
      .Option(impl.consumption())
      .map(value => zio.aws.mediatailor.model.PrefetchConsumption.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val playbackConfigurationName: Option[__string] = scala
      .Option(impl.playbackConfigurationName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val retrieval
        : Option[zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly] = scala
      .Option(impl.retrieval())
      .map(value => zio.aws.mediatailor.model.PrefetchRetrieval.wrap(value))
    override val streamId: Option[__string] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleResponse
  ): zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
