package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePrefetchScheduleRequest(
    consumption: zio.aws.mediatailor.model.PrefetchConsumption,
    name: __string,
    playbackConfigurationName: __string,
    retrieval: zio.aws.mediatailor.model.PrefetchRetrieval,
    streamId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest = {
    import CreatePrefetchScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest
      .builder()
      .consumption(consumption.buildAwsValue())
      .name(__string.unwrap(name): java.lang.String)
      .playbackConfigurationName(
        __string.unwrap(playbackConfigurationName): java.lang.String
      )
      .retrieval(retrieval.buildAwsValue())
      .optionallyWith(
        streamId.map(value => __string.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.CreatePrefetchScheduleRequest.ReadOnly =
    zio.aws.mediatailor.model.CreatePrefetchScheduleRequest
      .wrap(buildAwsValue())
}
object CreatePrefetchScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreatePrefetchScheduleRequest =
      zio.aws.mediatailor.model.CreatePrefetchScheduleRequest(
        consumption.asEditable,
        name,
        playbackConfigurationName,
        retrieval.asEditable,
        streamId.map(value => value)
      )
    def consumption: zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly
    def name: __string
    def playbackConfigurationName: __string
    def retrieval: zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly
    def streamId: Option[__string]
    def getConsumption: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly
    ] = ZIO.succeed(consumption)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getPlaybackConfigurationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(playbackConfigurationName)
    def getRetrieval: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly
    ] = ZIO.succeed(retrieval)
    def getStreamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest
  ) extends zio.aws.mediatailor.model.CreatePrefetchScheduleRequest.ReadOnly {
    override val consumption
        : zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly =
      zio.aws.mediatailor.model.PrefetchConsumption.wrap(impl.consumption())
    override val name: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.name())
    override val playbackConfigurationName: __string =
      zio.aws.mediatailor.model.primitives
        .__string(impl.playbackConfigurationName())
    override val retrieval
        : zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly =
      zio.aws.mediatailor.model.PrefetchRetrieval.wrap(impl.retrieval())
    override val streamId: Option[__string] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreatePrefetchScheduleRequest
  ): zio.aws.mediatailor.model.CreatePrefetchScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
