package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__string, __integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConfigureLogsForPlaybackConfigurationResponse(
    percentEnabled: Option[__integer] = None,
    playbackConfigurationName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse = {
    import ConfigureLogsForPlaybackConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
      .builder()
      .optionallyWith(
        percentEnabled.map(value => __integer.unwrap(value): Integer)
      )(_.percentEnabled)
      .optionallyWith(
        playbackConfigurationName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.playbackConfigurationName)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly =
    zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
      .wrap(buildAwsValue())
}
object ConfigureLogsForPlaybackConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse =
      zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse(
        percentEnabled.map(value => value),
        playbackConfigurationName.map(value => value)
      )
    def percentEnabled: Option[__integer]
    def playbackConfigurationName: Option[__string]
    def getPercentEnabled: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("percentEnabled", percentEnabled)
    def getPlaybackConfigurationName: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("playbackConfigurationName", playbackConfigurationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
  ) extends zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly {
    override val percentEnabled: Option[__integer] = scala
      .Option(impl.percentEnabled())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val playbackConfigurationName: Option[__string] = scala
      .Option(impl.playbackConfigurationName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse
  ): zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
