package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Bumper(
    endUrl: Option[__string] = None,
    startUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.Bumper = {
    import Bumper.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.Bumper
      .builder()
      .optionallyWith(
        endUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.endUrl)
      .optionallyWith(
        startUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.startUrl)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.Bumper.ReadOnly =
    zio.aws.mediatailor.model.Bumper.wrap(buildAwsValue())
}
object Bumper {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.Bumper
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.Bumper = zio.aws.mediatailor.model
      .Bumper(endUrl.map(value => value), startUrl.map(value => value))
    def endUrl: Option[__string]
    def startUrl: Option[__string]
    def getEndUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endUrl", endUrl)
    def getStartUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startUrl", startUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.Bumper
  ) extends zio.aws.mediatailor.model.Bumper.ReadOnly {
    override val endUrl: Option[__string] = scala
      .Option(impl.endUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val startUrl: Option[__string] = scala
      .Option(impl.startUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.Bumper
  ): zio.aws.mediatailor.model.Bumper.ReadOnly = new Wrapper(impl)
}
