package zio.aws.mediastoredata.model
import zio.aws.mediastoredata.model.primitives.{
  PaginationToken,
  ListLimit,
  ListPathNaming
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListItemsRequest(
    path: Optional[ListPathNaming] = Optional.Absent,
    maxResults: Optional[ListLimit] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest = {
    import ListItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
      .builder()
      .optionallyWith(
        path.map(value => ListPathNaming.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        maxResults.map(value => ListLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.ListItemsRequest.ReadOnly =
    zio.aws.mediastoredata.model.ListItemsRequest.wrap(buildAwsValue())
}
object ListItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.ListItemsRequest =
      zio.aws.mediastoredata.model.ListItemsRequest(
        path.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def path: Optional[ListPathNaming]
    def maxResults: Optional[ListLimit]
    def nextToken: Optional[PaginationToken]
    def getPath: ZIO[Any, AwsError, ListPathNaming] =
      AwsError.unwrapOptionField("path", path)
    def getMaxResults: ZIO[Any, AwsError, ListLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
  ) extends zio.aws.mediastoredata.model.ListItemsRequest.ReadOnly {
    override val path: Optional[ListPathNaming] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.ListPathNaming(value)
      )
    override val maxResults: Optional[ListLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mediastoredata.model.primitives.ListLimit(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
  ): zio.aws.mediastoredata.model.ListItemsRequest.ReadOnly = new Wrapper(impl)
}
