package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastoredata.model.primitives.PathNaming
import scala.jdk.CollectionConverters.*
final case class DescribeObjectRequest(path: PathNaming) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest = {
    import DescribeObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest
      .builder()
      .path(PathNaming.unwrap(path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.DescribeObjectRequest.ReadOnly =
    zio.aws.mediastoredata.model.DescribeObjectRequest.wrap(buildAwsValue())
}
object DescribeObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.DescribeObjectRequest =
      zio.aws.mediastoredata.model.DescribeObjectRequest(path)
    def path: PathNaming
    def getPath: ZIO[Any, Nothing, PathNaming] = ZIO.succeed(path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest
  ) extends zio.aws.mediastoredata.model.DescribeObjectRequest.ReadOnly {
    override val path: PathNaming =
      zio.aws.mediastoredata.model.primitives.PathNaming(impl.path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest
  ): zio.aws.mediastoredata.model.DescribeObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
