package zio.aws.mediastoredata.model
import scala.jdk.CollectionConverters.*
sealed trait ItemType {
  def unwrap: software.amazon.awssdk.services.mediastoredata.model.ItemType
}
object ItemType {
  def wrap(
      value: software.amazon.awssdk.services.mediastoredata.model.ItemType
  ): zio.aws.mediastoredata.model.ItemType = value match {
    case software.amazon.awssdk.services.mediastoredata.model.ItemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediastoredata.model.ItemType.OBJECT =>
      val r = OBJECT
      r
    case software.amazon.awssdk.services.mediastoredata.model.ItemType.FOLDER =>
      val r = FOLDER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediastoredata.model.ItemType {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.ItemType =
      software.amazon.awssdk.services.mediastoredata.model.ItemType.UNKNOWN_TO_SDK_VERSION
  }
  case object OBJECT extends zio.aws.mediastoredata.model.ItemType {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.ItemType =
      software.amazon.awssdk.services.mediastoredata.model.ItemType.OBJECT
  }
  case object FOLDER extends zio.aws.mediastoredata.model.ItemType {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.ItemType =
      software.amazon.awssdk.services.mediastoredata.model.ItemType.FOLDER
  }
}
