package zio.aws.mediastoredata.model
import scala.jdk.CollectionConverters.*
sealed trait StorageClass {
  def unwrap: software.amazon.awssdk.services.mediastoredata.model.StorageClass
}
object StorageClass {
  def wrap(
      value: software.amazon.awssdk.services.mediastoredata.model.StorageClass
  ): zio.aws.mediastoredata.model.StorageClass = value match {
    case software.amazon.awssdk.services.mediastoredata.model.StorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediastoredata.model.StorageClass.TEMPORAL =>
      val r = TEMPORAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediastoredata.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.StorageClass =
      software.amazon.awssdk.services.mediastoredata.model.StorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object TEMPORAL extends zio.aws.mediastoredata.model.StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.StorageClass =
      software.amazon.awssdk.services.mediastoredata.model.StorageClass.TEMPORAL
  }
}
