package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mediastoredata.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListItemsResponse(
    items: Optional[Iterable[zio.aws.mediastoredata.model.Item]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse = {
    import ListItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly =
    zio.aws.mediastoredata.model.ListItemsResponse.wrap(buildAwsValue())
}
object ListItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.ListItemsResponse =
      zio.aws.mediastoredata.model.ListItemsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.mediastoredata.model.Item.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.mediastoredata.model.Item.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse
  ) extends zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.mediastoredata.model.Item.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediastoredata.model.Item.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse
  ): zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly = new Wrapper(impl)
}
