package zio.aws.mediastoredata
import zio.mock.{Proxy, Mock}
import zio.aws.mediastoredata.model.DeleteObjectResponse.ReadOnly
import zio.aws.core.{StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.mediastoredata.model.{
  DescribeObjectRequest,
  PutObjectRequest,
  ListItemsRequest,
  GetObjectRequest,
  DeleteObjectRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object MediaStoreDataMock extends Mock[MediaStoreData] {
  object DeleteObject extends Effect[DeleteObjectRequest, AwsError, ReadOnly]
  object PutObject
      extends Effect[
        Tuple2[PutObjectRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly
      ]
  object GetObject
      extends Effect[GetObjectRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly,
        Byte
      ]]
  object ListItems
      extends Stream[
        ListItemsRequest,
        AwsError,
        zio.aws.mediastoredata.model.Item.ReadOnly
      ]
  object ListItemsPaginated
      extends Effect[
        ListItemsRequest,
        AwsError,
        zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly
      ]
  object DescribeObject
      extends Effect[
        DescribeObjectRequest,
        AwsError,
        zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaStoreData] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MediaStoreData] { rts =>
        zio.ZIO.succeed {
          new MediaStoreData {
            val api: MediaStoreDataAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MediaStoreData = this
            def deleteObject(
                request: DeleteObjectRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteObject, request)
            def putObject(
                request: PutObjectRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[
              AwsError,
              zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly
            ] = proxy(PutObject, request, body)
            def getObject(
                request: GetObjectRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly,
              Byte
            ]] = proxy(GetObject, request)
            def listItems(request: ListItemsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.mediastoredata.model.Item.ReadOnly
            ] = rts.unsafeRun(proxy(ListItems, request))
            def listItemsPaginated(request: ListItemsRequest): IO[
              AwsError,
              zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly
            ] = proxy(ListItemsPaginated, request)
            def describeObject(request: DescribeObjectRequest): IO[
              AwsError,
              zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly
            ] = proxy(DescribeObject, request)
          }
        }
      }
    }
  }
}
