package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastoredata.model.primitives.PathNaming
import scala.jdk.CollectionConverters.*
final case class DeleteObjectRequest(path: PathNaming) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest = {
    import DeleteObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest
      .builder()
      .path(PathNaming.unwrap(path): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.DeleteObjectRequest.ReadOnly =
    zio.aws.mediastoredata.model.DeleteObjectRequest.wrap(buildAwsValue())
}
object DeleteObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.DeleteObjectRequest =
      zio.aws.mediastoredata.model.DeleteObjectRequest(path)
    def path: PathNaming
    def getPath: ZIO[Any, Nothing, PathNaming] = ZIO.succeed(path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest
  ) extends zio.aws.mediastoredata.model.DeleteObjectRequest.ReadOnly {
    override val path: PathNaming =
      zio.aws.mediastoredata.model.primitives.PathNaming(impl.path())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest
  ): zio.aws.mediastoredata.model.DeleteObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
