package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastoredata.model.primitives.{
  ContentType,
  ETag,
  NonNegativeLong,
  ItemName,
  TimeStamp
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Item(
    name: Option[ItemName] = None,
    `type`: Option[zio.aws.mediastoredata.model.ItemType] = None,
    eTag: Option[ETag] = None,
    lastModified: Option[TimeStamp] = None,
    contentType: Option[ContentType] = None,
    contentLength: Option[NonNegativeLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.Item = {
    import Item.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.Item
      .builder()
      .optionallyWith(
        name.map(value => ItemName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        lastModified.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        contentLength.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.Item.ReadOnly =
    zio.aws.mediastoredata.model.Item.wrap(buildAwsValue())
}
object Item {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.Item
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.Item =
      zio.aws.mediastoredata.model.Item(
        name.map(value => value),
        `type`.map(value => value),
        eTag.map(value => value),
        lastModified.map(value => value),
        contentType.map(value => value),
        contentLength.map(value => value)
      )
    def name: Option[ItemName]
    def `type`: Option[zio.aws.mediastoredata.model.ItemType]
    def eTag: Option[ETag]
    def lastModified: Option[TimeStamp]
    def contentType: Option[ContentType]
    def contentLength: Option[NonNegativeLong]
    def getName: ZIO[Any, AwsError, ItemName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.mediastoredata.model.ItemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModified: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentLength: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("contentLength", contentLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.Item
  ) extends zio.aws.mediastoredata.model.Item.ReadOnly {
    override val name: Option[ItemName] = scala
      .Option(impl.name())
      .map(value => zio.aws.mediastoredata.model.primitives.ItemName(value))
    override val `type`: Option[zio.aws.mediastoredata.model.ItemType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.mediastoredata.model.ItemType.wrap(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val lastModified: Option[TimeStamp] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.mediastoredata.model.primitives.TimeStamp(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.mediastoredata.model.primitives.ContentType(value))
    override val contentLength: Option[NonNegativeLong] = scala
      .Option(impl.contentLength())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.NonNegativeLong(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.Item
  ): zio.aws.mediastoredata.model.Item.ReadOnly = new Wrapper(impl)
}
