package zio.aws.mediastoredata.model
import java.time.Instant
import zio.aws.mediastoredata.model.primitives.{
  ContentType,
  ETag,
  NonNegativeLong,
  ItemName,
  TimeStamp
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Item(
    name: Optional[ItemName] = Optional.Absent,
    `type`: Optional[zio.aws.mediastoredata.model.ItemType] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    lastModified: Optional[TimeStamp] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    contentLength: Optional[NonNegativeLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.Item = {
    import Item.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.Item
      .builder()
      .optionallyWith(
        name.map(value => ItemName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        lastModified.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        contentLength.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.Item.ReadOnly =
    zio.aws.mediastoredata.model.Item.wrap(buildAwsValue())
}
object Item {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.Item
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.Item =
      zio.aws.mediastoredata.model.Item(
        name.map(value => value),
        `type`.map(value => value),
        eTag.map(value => value),
        lastModified.map(value => value),
        contentType.map(value => value),
        contentLength.map(value => value)
      )
    def name: Optional[ItemName]
    def `type`: Optional[zio.aws.mediastoredata.model.ItemType]
    def eTag: Optional[ETag]
    def lastModified: Optional[TimeStamp]
    def contentType: Optional[ContentType]
    def contentLength: Optional[NonNegativeLong]
    def getName: ZIO[Any, AwsError, ItemName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.mediastoredata.model.ItemType] =
      AwsError.unwrapOptionField("type", `type`)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModified: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentLength: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("contentLength", contentLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.Item
  ) extends zio.aws.mediastoredata.model.Item.ReadOnly {
    override val name: Optional[ItemName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.mediastoredata.model.primitives.ItemName(value))
    override val `type`: Optional[zio.aws.mediastoredata.model.ItemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.mediastoredata.model.ItemType.wrap(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val lastModified: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.mediastoredata.model.primitives.TimeStamp(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.mediastoredata.model.primitives.ContentType(value))
    override val contentLength: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLength())
        .map(value =>
          zio.aws.mediastoredata.model.primitives.NonNegativeLong(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.Item
  ): zio.aws.mediastoredata.model.Item.ReadOnly = new Wrapper(impl)
}
