package zio.aws.mediastoredata.model
import java.time.Instant
import zio.aws.mediastoredata.model.primitives.{
  ContentType,
  ETag,
  NonNegativeLong,
  StringPrimitive,
  StatusCode,
  ContentRangePattern,
  TimeStamp
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetObjectResponse(
    cacheControl: Optional[StringPrimitive] = Optional.Absent,
    contentRange: Optional[ContentRangePattern] = Optional.Absent,
    contentLength: Optional[NonNegativeLong] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    lastModified: Optional[TimeStamp] = Optional.Absent,
    statusCode: StatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse = {
    import GetObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse
      .builder()
      .optionallyWith(
        cacheControl.map(value =>
          StringPrimitive.unwrap(value): java.lang.String
        )
      )(_.cacheControl)
      .optionallyWith(
        contentRange.map(value =>
          ContentRangePattern.unwrap(value): java.lang.String
        )
      )(_.contentRange)
      .optionallyWith(
        contentLength.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        lastModified.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModified)
      .statusCode(StatusCode.unwrap(statusCode): Integer)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly =
    zio.aws.mediastoredata.model.GetObjectResponse.wrap(buildAwsValue())
}
object GetObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.GetObjectResponse =
      zio.aws.mediastoredata.model.GetObjectResponse(
        cacheControl.map(value => value),
        contentRange.map(value => value),
        contentLength.map(value => value),
        contentType.map(value => value),
        eTag.map(value => value),
        lastModified.map(value => value),
        statusCode
      )
    def cacheControl: Optional[StringPrimitive]
    def contentRange: Optional[ContentRangePattern]
    def contentLength: Optional[NonNegativeLong]
    def contentType: Optional[ContentType]
    def eTag: Optional[ETag]
    def lastModified: Optional[TimeStamp]
    def statusCode: StatusCode
    def getCacheControl: ZIO[Any, AwsError, StringPrimitive] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentRange: ZIO[Any, AwsError, ContentRangePattern] =
      AwsError.unwrapOptionField("contentRange", contentRange)
    def getContentLength: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModified: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getStatusCode: ZIO[Any, Nothing, StatusCode] = ZIO.succeed(statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse
  ) extends zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly {
    override val cacheControl: Optional[StringPrimitive] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.StringPrimitive(value)
      )
    override val contentRange: Optional[ContentRangePattern] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentRange())
        .map(value =>
          zio.aws.mediastoredata.model.primitives.ContentRangePattern(value)
        )
    override val contentLength: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLength())
        .map(value =>
          zio.aws.mediastoredata.model.primitives.NonNegativeLong(value)
        )
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.mediastoredata.model.primitives.ContentType(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val lastModified: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.mediastoredata.model.primitives.TimeStamp(value))
    override val statusCode: StatusCode =
      zio.aws.mediastoredata.model.primitives.StatusCode(impl.statusCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse
  ): zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly = new Wrapper(impl)
}
