package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mediastoredata.model.primitives.{ETag, SHA256Hash}
import scala.jdk.CollectionConverters._
final case class PutObjectResponse(
    contentSHA256: Optional[SHA256Hash] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    storageClass: Optional[zio.aws.mediastoredata.model.StorageClass] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse = {
    import PutObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
      .builder()
      .optionallyWith(
        contentSHA256.map(value => SHA256Hash.unwrap(value): java.lang.String)
      )(_.contentSHA256)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly =
    zio.aws.mediastoredata.model.PutObjectResponse.wrap(buildAwsValue())
}
object PutObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.PutObjectResponse =
      zio.aws.mediastoredata.model.PutObjectResponse(
        contentSHA256.map(value => value),
        eTag.map(value => value),
        storageClass.map(value => value)
      )
    def contentSHA256: Optional[SHA256Hash]
    def eTag: Optional[ETag]
    def storageClass: Optional[zio.aws.mediastoredata.model.StorageClass]
    def getContentSHA256: ZIO[Any, AwsError, SHA256Hash] =
      AwsError.unwrapOptionField("contentSHA256", contentSHA256)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.mediastoredata.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
  ) extends zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly {
    override val contentSHA256: Optional[SHA256Hash] = zio.aws.core.internal
      .optionalFromNullable(impl.contentSHA256())
      .map(value => zio.aws.mediastoredata.model.primitives.SHA256Hash(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val storageClass
        : Optional[zio.aws.mediastoredata.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.mediastoredata.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
  ): zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly = new Wrapper(impl)
}
