package zio.aws.mediastoredata.model
import java.time.Instant
import zio.aws.mediastoredata.model.primitives.{
  ContentType,
  ETag,
  NonNegativeLong,
  StringPrimitive,
  TimeStamp
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeObjectResponse(
    eTag: Optional[ETag] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    contentLength: Optional[NonNegativeLong] = Optional.Absent,
    cacheControl: Optional[StringPrimitive] = Optional.Absent,
    lastModified: Optional[TimeStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse = {
    import DescribeObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        contentLength.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .optionallyWith(
        cacheControl.map(value =>
          StringPrimitive.unwrap(value): java.lang.String
        )
      )(_.cacheControl)
      .optionallyWith(
        lastModified.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly =
    zio.aws.mediastoredata.model.DescribeObjectResponse.wrap(buildAwsValue())
}
object DescribeObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.DescribeObjectResponse =
      zio.aws.mediastoredata.model.DescribeObjectResponse(
        eTag.map(value => value),
        contentType.map(value => value),
        contentLength.map(value => value),
        cacheControl.map(value => value),
        lastModified.map(value => value)
      )
    def eTag: Optional[ETag]
    def contentType: Optional[ContentType]
    def contentLength: Optional[NonNegativeLong]
    def cacheControl: Optional[StringPrimitive]
    def lastModified: Optional[TimeStamp]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentLength: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getCacheControl: ZIO[Any, AwsError, StringPrimitive] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getLastModified: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
  ) extends zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly {
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.mediastoredata.model.primitives.ContentType(value))
    override val contentLength: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLength())
        .map(value =>
          zio.aws.mediastoredata.model.primitives.NonNegativeLong(value)
        )
    override val cacheControl: Optional[StringPrimitive] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.StringPrimitive(value)
      )
    override val lastModified: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.mediastoredata.model.primitives.TimeStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
  ): zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
