package zio.aws.mediastoredata.model
import scala.jdk.CollectionConverters._
sealed trait UploadAvailability {
  def unwrap
      : software.amazon.awssdk.services.mediastoredata.model.UploadAvailability
}
object UploadAvailability {
  def wrap(
      value: software.amazon.awssdk.services.mediastoredata.model.UploadAvailability
  ): zio.aws.mediastoredata.model.UploadAvailability = value match {
    case software.amazon.awssdk.services.mediastoredata.model.UploadAvailability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediastoredata.model.UploadAvailability.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.mediastoredata.model.UploadAvailability.STREAMING =>
      val r = STREAMING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediastoredata.model.UploadAvailability {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.UploadAvailability =
      software.amazon.awssdk.services.mediastoredata.model.UploadAvailability.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.mediastoredata.model.UploadAvailability {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.UploadAvailability =
      software.amazon.awssdk.services.mediastoredata.model.UploadAvailability.STANDARD
  }
  case object STREAMING
      extends zio.aws.mediastoredata.model.UploadAvailability {
    override def unwrap
        : software.amazon.awssdk.services.mediastoredata.model.UploadAvailability =
      software.amazon.awssdk.services.mediastoredata.model.UploadAvailability.STREAMING
  }
}
