package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.mediastoredata.model.primitives.{RangePattern, PathNaming}
import scala.jdk.CollectionConverters._
final case class GetObjectRequest(
    path: PathNaming,
    range: Optional[RangePattern] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest = {
    import GetObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest
      .builder()
      .path(PathNaming.unwrap(path): java.lang.String)
      .optionallyWith(
        range.map(value => RangePattern.unwrap(value): java.lang.String)
      )(_.range)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.GetObjectRequest.ReadOnly =
    zio.aws.mediastoredata.model.GetObjectRequest.wrap(buildAwsValue())
}
object GetObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.GetObjectRequest =
      zio.aws.mediastoredata.model
        .GetObjectRequest(path, range.map(value => value))
    def path: PathNaming
    def range: Optional[RangePattern]
    def getPath: ZIO[Any, Nothing, PathNaming] = ZIO.succeed(path)
    def getRange: ZIO[Any, AwsError, RangePattern] =
      AwsError.unwrapOptionField("range", range)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest
  ) extends zio.aws.mediastoredata.model.GetObjectRequest.ReadOnly {
    override val path: PathNaming =
      zio.aws.mediastoredata.model.primitives.PathNaming(impl.path())
    override val range: Optional[RangePattern] = zio.aws.core.internal
      .optionalFromNullable(impl.range())
      .map(value => zio.aws.mediastoredata.model.primitives.RangePattern(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest
  ): zio.aws.mediastoredata.model.GetObjectRequest.ReadOnly = new Wrapper(impl)
}
