package zio.aws.mediastoredata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastoredata.model.primitives.{
  PaginationToken,
  ListLimit,
  ListPathNaming
}
import scala.jdk.CollectionConverters._
final case class ListItemsRequest(
    path: Option[ListPathNaming] = None,
    maxResults: Option[ListLimit] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest = {
    import ListItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
      .builder()
      .optionallyWith(
        path.map(value => ListPathNaming.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        maxResults.map(value => ListLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.ListItemsRequest.ReadOnly =
    zio.aws.mediastoredata.model.ListItemsRequest.wrap(buildAwsValue())
}
object ListItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.ListItemsRequest =
      zio.aws.mediastoredata.model.ListItemsRequest(
        path.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def path: Option[ListPathNaming]
    def maxResults: Option[ListLimit]
    def nextToken: Option[PaginationToken]
    def getPath: ZIO[Any, AwsError, ListPathNaming] =
      AwsError.unwrapOptionField("path", path)
    def getMaxResults: ZIO[Any, AwsError, ListLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
  ) extends zio.aws.mediastoredata.model.ListItemsRequest.ReadOnly {
    override val path: Option[ListPathNaming] = scala
      .Option(impl.path())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.ListPathNaming(value)
      )
    override val maxResults: Option[ListLimit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediastoredata.model.primitives.ListLimit(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest
  ): zio.aws.mediastoredata.model.ListItemsRequest.ReadOnly = new Wrapper(impl)
}
