package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastoredata.model.primitives.{
  StringPrimitive,
  ContentType,
  PathNaming
}
import scala.jdk.CollectionConverters._
final case class PutObjectRequest(
    path: PathNaming,
    contentType: Option[ContentType] = None,
    cacheControl: Option[StringPrimitive] = None,
    storageClass: Option[zio.aws.mediastoredata.model.StorageClass] = None,
    uploadAvailability: Option[
      zio.aws.mediastoredata.model.UploadAvailability
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest = {
    import PutObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest
      .builder()
      .path(PathNaming.unwrap(path): java.lang.String)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        cacheControl.map(value =>
          StringPrimitive.unwrap(value): java.lang.String
        )
      )(_.cacheControl)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(uploadAvailability.map(value => value.unwrap))(
        _.uploadAvailability
      )
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.PutObjectRequest.ReadOnly =
    zio.aws.mediastoredata.model.PutObjectRequest.wrap(buildAwsValue())
}
object PutObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.PutObjectRequest =
      zio.aws.mediastoredata.model.PutObjectRequest(
        path,
        contentType.map(value => value),
        cacheControl.map(value => value),
        storageClass.map(value => value),
        uploadAvailability.map(value => value)
      )
    def path: PathNaming
    def contentType: Option[ContentType]
    def cacheControl: Option[StringPrimitive]
    def storageClass: Option[zio.aws.mediastoredata.model.StorageClass]
    def uploadAvailability
        : Option[zio.aws.mediastoredata.model.UploadAvailability]
    def getPath: ZIO[Any, Nothing, PathNaming] = ZIO.succeed(path)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCacheControl: ZIO[Any, AwsError, StringPrimitive] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.mediastoredata.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getUploadAvailability
        : ZIO[Any, AwsError, zio.aws.mediastoredata.model.UploadAvailability] =
      AwsError.unwrapOptionField("uploadAvailability", uploadAvailability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest
  ) extends zio.aws.mediastoredata.model.PutObjectRequest.ReadOnly {
    override val path: PathNaming =
      zio.aws.mediastoredata.model.primitives.PathNaming(impl.path())
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.mediastoredata.model.primitives.ContentType(value))
    override val cacheControl: Option[StringPrimitive] = scala
      .Option(impl.cacheControl())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.StringPrimitive(value)
      )
    override val storageClass
        : Option[zio.aws.mediastoredata.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.mediastoredata.model.StorageClass.wrap(value))
    override val uploadAvailability
        : Option[zio.aws.mediastoredata.model.UploadAvailability] = scala
      .Option(impl.uploadAvailability())
      .map(value => zio.aws.mediastoredata.model.UploadAvailability.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest
  ): zio.aws.mediastoredata.model.PutObjectRequest.ReadOnly = new Wrapper(impl)
}
