package zio.aws.mediastoredata
import zio.aws.core.config.AwsConfig
import zio.aws.mediastoredata.model.DeleteObjectResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.mediastoredata.{
  MediaStoreDataAsyncClientBuilder,
  MediaStoreDataAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.mediastoredata.model.{
  DescribeObjectRequest,
  PutObjectRequest,
  ListItemsRequest,
  GetObjectRequest,
  DeleteObjectRequest
}
import zio.{ZEnvironment, Task, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.mediastoredata.model.{
  GetObjectResponse,
  Item,
  DeleteObjectResponse,
  PutObjectResponse,
  ListItemsResponse,
  DescribeObjectResponse
}
import scala.jdk.CollectionConverters._
trait MediaStoreData extends AspectSupport[MediaStoreData] {
  val api: MediaStoreDataAsyncClient
  def deleteObject(request: DeleteObjectRequest): IO[AwsError, ReadOnly]
  def putObject(
      request: PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly]
  def getObject(request: GetObjectRequest): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly,
    Byte
  ]]
  def listItems(
      request: ListItemsRequest
  ): ZStream[Any, AwsError, zio.aws.mediastoredata.model.Item.ReadOnly]
  def listItemsPaginated(
      request: ListItemsRequest
  ): IO[AwsError, zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly]
  def describeObject(
      request: DescribeObjectRequest
  ): IO[AwsError, zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly]
}
object MediaStoreData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaStoreData] = customized(
    identity
  )
  def customized(
      customization: MediaStoreDataAsyncClientBuilder => MediaStoreDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaStoreData] = managed(
    customization
  ).toLayer
  def managed(
      customization: MediaStoreDataAsyncClientBuilder => MediaStoreDataAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, MediaStoreData] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = MediaStoreDataAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaStoreDataAsyncClient, MediaStoreDataAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        MediaStoreDataAsyncClient,
        MediaStoreDataAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new MediaStoreDataImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MediaStoreDataImpl[R](
      override val api: MediaStoreDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaStoreData
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaStoreData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaStoreDataImpl[R1] = new MediaStoreDataImpl(api, newAspect, r)
    def deleteObject(request: DeleteObjectRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest,
        DeleteObjectResponse
      ]("deleteObject", api.deleteObject)(request.buildAwsValue())
        .map(zio.aws.mediastoredata.model.DeleteObjectResponse.wrap)
        .provideEnvironment(r)
    def putObject(
        request: PutObjectRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly] =
      asyncRequestInputStream[
        software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest,
        PutObjectResponse
      ]("putObject", api.putObject)(request.buildAwsValue(), body)
        .map(zio.aws.mediastoredata.model.PutObjectResponse.wrap)
        .provideEnvironment(r)
    def getObject(
        request: GetObjectRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest,
      GetObjectResponse
    ](
      "getObject",
      api.getObject[Task[StreamingOutputResult[R, GetObjectResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.mediastoredata.model.GetObjectResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listItems(
        request: ListItemsRequest
    ): ZStream[Any, AwsError, zio.aws.mediastoredata.model.Item.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest,
        ListItemsResponse,
        Item
      ](
        "listItems",
        api.listItems,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.mediastoredata.model.Item.wrap(item))
        .provideEnvironment(r)
    def listItemsPaginated(
        request: ListItemsRequest
    ): IO[AwsError, zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest,
        ListItemsResponse
      ]("listItems", api.listItems)(request.buildAwsValue())
        .map(zio.aws.mediastoredata.model.ListItemsResponse.wrap)
        .provideEnvironment(r)
    def describeObject(request: DescribeObjectRequest): IO[
      AwsError,
      zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest,
      DescribeObjectResponse
    ]("describeObject", api.describeObject)(request.buildAwsValue())
      .map(zio.aws.mediastoredata.model.DescribeObjectResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteObject(
      request: DeleteObjectRequest
  ): ZIO[zio.aws.mediastoredata.MediaStoreData, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteObject(request))
  def putObject(
      request: PutObjectRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.mediastoredata.MediaStoreData,
    AwsError,
    zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putObject(request, body))
  def getObject(
      request: GetObjectRequest
  ): ZIO[zio.aws.mediastoredata.MediaStoreData, AwsError, StreamingOutputResult[
    Any,
    zio.aws.mediastoredata.model.GetObjectResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getObject(request))
  def listItems(request: ListItemsRequest): ZStream[
    zio.aws.mediastoredata.MediaStoreData,
    AwsError,
    zio.aws.mediastoredata.model.Item.ReadOnly
  ] = ZStream.serviceWithStream(_.listItems(request))
  def listItemsPaginated(request: ListItemsRequest): ZIO[
    zio.aws.mediastoredata.MediaStoreData,
    AwsError,
    zio.aws.mediastoredata.model.ListItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listItemsPaginated(request))
  def describeObject(request: DescribeObjectRequest): ZIO[
    zio.aws.mediastoredata.MediaStoreData,
    AwsError,
    zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeObject(request))
}
