package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastoredata.model.primitives.{ETag, SHA256Hash}
import scala.jdk.CollectionConverters._
final case class PutObjectResponse(
    contentSHA256: Option[SHA256Hash] = None,
    eTag: Option[ETag] = None,
    storageClass: Option[zio.aws.mediastoredata.model.StorageClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse = {
    import PutObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
      .builder()
      .optionallyWith(
        contentSHA256.map(value => SHA256Hash.unwrap(value): java.lang.String)
      )(_.contentSHA256)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly =
    zio.aws.mediastoredata.model.PutObjectResponse.wrap(buildAwsValue())
}
object PutObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.PutObjectResponse =
      zio.aws.mediastoredata.model.PutObjectResponse(
        contentSHA256.map(value => value),
        eTag.map(value => value),
        storageClass.map(value => value)
      )
    def contentSHA256: Option[SHA256Hash]
    def eTag: Option[ETag]
    def storageClass: Option[zio.aws.mediastoredata.model.StorageClass]
    def getContentSHA256: ZIO[Any, AwsError, SHA256Hash] =
      AwsError.unwrapOptionField("contentSHA256", contentSHA256)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.mediastoredata.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
  ) extends zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly {
    override val contentSHA256: Option[SHA256Hash] = scala
      .Option(impl.contentSHA256())
      .map(value => zio.aws.mediastoredata.model.primitives.SHA256Hash(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val storageClass
        : Option[zio.aws.mediastoredata.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.mediastoredata.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse
  ): zio.aws.mediastoredata.model.PutObjectResponse.ReadOnly = new Wrapper(impl)
}
