package zio.aws.mediastoredata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastoredata.model.primitives.{
  ContentType,
  ETag,
  NonNegativeLong,
  StringPrimitive,
  TimeStamp
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeObjectResponse(
    eTag: Option[ETag] = None,
    contentType: Option[ContentType] = None,
    contentLength: Option[NonNegativeLong] = None,
    cacheControl: Option[StringPrimitive] = None,
    lastModified: Option[TimeStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse = {
    import DescribeObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        contentLength.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.contentLength)
      .optionallyWith(
        cacheControl.map(value =>
          StringPrimitive.unwrap(value): java.lang.String
        )
      )(_.cacheControl)
      .optionallyWith(
        lastModified.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModified)
      .build()
  }
  def asReadOnly: zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly =
    zio.aws.mediastoredata.model.DescribeObjectResponse.wrap(buildAwsValue())
}
object DescribeObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastoredata.model.DescribeObjectResponse =
      zio.aws.mediastoredata.model.DescribeObjectResponse(
        eTag.map(value => value),
        contentType.map(value => value),
        contentLength.map(value => value),
        cacheControl.map(value => value),
        lastModified.map(value => value)
      )
    def eTag: Option[ETag]
    def contentType: Option[ContentType]
    def contentLength: Option[NonNegativeLong]
    def cacheControl: Option[StringPrimitive]
    def lastModified: Option[TimeStamp]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getContentLength: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getCacheControl: ZIO[Any, AwsError, StringPrimitive] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getLastModified: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModified", lastModified)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
  ) extends zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly {
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.mediastoredata.model.primitives.ETag(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.mediastoredata.model.primitives.ContentType(value))
    override val contentLength: Option[NonNegativeLong] = scala
      .Option(impl.contentLength())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.NonNegativeLong(value)
      )
    override val cacheControl: Option[StringPrimitive] = scala
      .Option(impl.cacheControl())
      .map(value =>
        zio.aws.mediastoredata.model.primitives.StringPrimitive(value)
      )
    override val lastModified: Option[TimeStamp] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.mediastoredata.model.primitives.TimeStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse
  ): zio.aws.mediastoredata.model.DescribeObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
