package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastore.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListContainersResponse(
    containers: Iterable[zio.aws.mediastore.model.Container],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.ListContainersResponse = {
    import ListContainersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.ListContainersResponse
      .builder()
      .containers(containers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.ListContainersResponse.ReadOnly =
    zio.aws.mediastore.model.ListContainersResponse.wrap(buildAwsValue())
}
object ListContainersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.ListContainersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.ListContainersResponse =
      zio.aws.mediastore.model.ListContainersResponse(
        containers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def containers: List[zio.aws.mediastore.model.Container.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getContainers
        : ZIO[Any, Nothing, List[zio.aws.mediastore.model.Container.ReadOnly]] =
      ZIO.succeed(containers)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.ListContainersResponse
  ) extends zio.aws.mediastore.model.ListContainersResponse.ReadOnly {
    override val containers: List[zio.aws.mediastore.model.Container.ReadOnly] =
      impl
        .containers()
        .asScala
        .map { item =>
          zio.aws.mediastore.model.Container.wrap(item)
        }
        .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.mediastore.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.ListContainersResponse
  ): zio.aws.mediastore.model.ListContainersResponse.ReadOnly = new Wrapper(
    impl
  )
}
