package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class GetLifecyclePolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest = {
    import GetLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.GetLifecyclePolicyRequest.ReadOnly =
    zio.aws.mediastore.model.GetLifecyclePolicyRequest.wrap(buildAwsValue())
}
object GetLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.GetLifecyclePolicyRequest =
      zio.aws.mediastore.model.GetLifecyclePolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest
  ) extends zio.aws.mediastore.model.GetLifecyclePolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.GetLifecyclePolicyRequest
  ): zio.aws.mediastore.model.GetLifecyclePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
