package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetCorsPolicyResponse(
    corsPolicy: Iterable[zio.aws.mediastore.model.CorsRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.GetCorsPolicyResponse = {
    import GetCorsPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.GetCorsPolicyResponse
      .builder()
      .corsPolicy(corsPolicy.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly =
    zio.aws.mediastore.model.GetCorsPolicyResponse.wrap(buildAwsValue())
}
object GetCorsPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.GetCorsPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.GetCorsPolicyResponse =
      zio.aws.mediastore.model.GetCorsPolicyResponse(corsPolicy.map { item =>
        item.asEditable
      })
    def corsPolicy: List[zio.aws.mediastore.model.CorsRule.ReadOnly]
    def getCorsPolicy
        : ZIO[Any, Nothing, List[zio.aws.mediastore.model.CorsRule.ReadOnly]] =
      ZIO.succeed(corsPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.GetCorsPolicyResponse
  ) extends zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly {
    override val corsPolicy: List[zio.aws.mediastore.model.CorsRule.ReadOnly] =
      impl
        .corsPolicy()
        .asScala
        .map { item =>
          zio.aws.mediastore.model.CorsRule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.GetCorsPolicyResponse
  ): zio.aws.mediastore.model.GetCorsPolicyResponse.ReadOnly = new Wrapper(impl)
}
