package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class StopAccessLoggingRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest = {
    import StopAccessLoggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.StopAccessLoggingRequest.ReadOnly =
    zio.aws.mediastore.model.StopAccessLoggingRequest.wrap(buildAwsValue())
}
object StopAccessLoggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.StopAccessLoggingRequest =
      zio.aws.mediastore.model.StopAccessLoggingRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest
  ) extends zio.aws.mediastore.model.StopAccessLoggingRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.StopAccessLoggingRequest
  ): zio.aws.mediastore.model.StopAccessLoggingRequest.ReadOnly = new Wrapper(
    impl
  )
}
