package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class StartAccessLoggingRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest = {
    import StartAccessLoggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.StartAccessLoggingRequest.ReadOnly =
    zio.aws.mediastore.model.StartAccessLoggingRequest.wrap(buildAwsValue())
}
object StartAccessLoggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.StartAccessLoggingRequest =
      zio.aws.mediastore.model.StartAccessLoggingRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest
  ) extends zio.aws.mediastore.model.StartAccessLoggingRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.StartAccessLoggingRequest
  ): zio.aws.mediastore.model.StartAccessLoggingRequest.ReadOnly = new Wrapper(
    impl
  )
}
