package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.{ContainerPolicy, ContainerName}
import scala.jdk.CollectionConverters.*
final case class PutContainerPolicyRequest(
    containerName: ContainerName,
    policy: ContainerPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest = {
    import PutContainerPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .policy(ContainerPolicy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.PutContainerPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.PutContainerPolicyRequest.wrap(buildAwsValue())
}
object PutContainerPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.PutContainerPolicyRequest =
      zio.aws.mediastore.model.PutContainerPolicyRequest(containerName, policy)
    def containerName: ContainerName
    def policy: ContainerPolicy
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
    def getPolicy: ZIO[Any, Nothing, ContainerPolicy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest
  ) extends zio.aws.mediastore.model.PutContainerPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
    override val policy: ContainerPolicy =
      zio.aws.mediastore.model.primitives.ContainerPolicy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.PutContainerPolicyRequest
  ): zio.aws.mediastore.model.PutContainerPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
