package zio.aws.mediastore.model
import scala.jdk.CollectionConverters.*
sealed trait MethodName {
  def unwrap: software.amazon.awssdk.services.mediastore.model.MethodName
}
object MethodName {
  def wrap(
      value: software.amazon.awssdk.services.mediastore.model.MethodName
  ): zio.aws.mediastore.model.MethodName = value match {
    case software.amazon.awssdk.services.mediastore.model.MethodName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediastore.model.MethodName.PUT =>
      val r = PUT
      r
    case software.amazon.awssdk.services.mediastore.model.MethodName.GET =>
      val r = GET
      r
    case software.amazon.awssdk.services.mediastore.model.MethodName.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.mediastore.model.MethodName.HEAD =>
      val r = HEAD
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediastore.model.MethodName {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.MethodName =
      software.amazon.awssdk.services.mediastore.model.MethodName.UNKNOWN_TO_SDK_VERSION
  }
  case object PUT extends zio.aws.mediastore.model.MethodName {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.MethodName =
      software.amazon.awssdk.services.mediastore.model.MethodName.PUT
  }
  case object GET extends zio.aws.mediastore.model.MethodName {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.MethodName =
      software.amazon.awssdk.services.mediastore.model.MethodName.GET
  }
  case object DELETE extends zio.aws.mediastore.model.MethodName {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.MethodName =
      software.amazon.awssdk.services.mediastore.model.MethodName.DELETE
  }
  case object HEAD extends zio.aws.mediastore.model.MethodName {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.MethodName =
      software.amazon.awssdk.services.mediastore.model.MethodName.HEAD
  }
}
