package zio.aws.mediastore.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerStatus {
  def unwrap: software.amazon.awssdk.services.mediastore.model.ContainerStatus
}
object ContainerStatus {
  def wrap(
      value: software.amazon.awssdk.services.mediastore.model.ContainerStatus
  ): zio.aws.mediastore.model.ContainerStatus = value match {
    case software.amazon.awssdk.services.mediastore.model.ContainerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediastore.model.ContainerStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.mediastore.model.ContainerStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.mediastore.model.ContainerStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediastore.model.ContainerStatus {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerStatus =
      software.amazon.awssdk.services.mediastore.model.ContainerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.mediastore.model.ContainerStatus {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerStatus =
      software.amazon.awssdk.services.mediastore.model.ContainerStatus.ACTIVE
  }
  case object CREATING extends zio.aws.mediastore.model.ContainerStatus {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerStatus =
      software.amazon.awssdk.services.mediastore.model.ContainerStatus.CREATING
  }
  case object DELETING extends zio.aws.mediastore.model.ContainerStatus {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerStatus =
      software.amazon.awssdk.services.mediastore.model.ContainerStatus.DELETING
  }
}
