package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class DeleteCorsPolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest = {
    import DeleteCorsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.DeleteCorsPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.DeleteCorsPolicyRequest.wrap(buildAwsValue())
}
object DeleteCorsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DeleteCorsPolicyRequest =
      zio.aws.mediastore.model.DeleteCorsPolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest
  ) extends zio.aws.mediastore.model.DeleteCorsPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteCorsPolicyRequest
  ): zio.aws.mediastore.model.DeleteCorsPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
