package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.{LifecyclePolicy, ContainerName}
import scala.jdk.CollectionConverters.*
final case class PutLifecyclePolicyRequest(
    containerName: ContainerName,
    lifecyclePolicy: LifecyclePolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest = {
    import PutLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .lifecyclePolicy(
        LifecyclePolicy.unwrap(lifecyclePolicy): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.PutLifecyclePolicyRequest.ReadOnly =
    zio.aws.mediastore.model.PutLifecyclePolicyRequest.wrap(buildAwsValue())
}
object PutLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.PutLifecyclePolicyRequest =
      zio.aws.mediastore.model
        .PutLifecyclePolicyRequest(containerName, lifecyclePolicy)
    def containerName: ContainerName
    def lifecyclePolicy: LifecyclePolicy
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
    def getLifecyclePolicy: ZIO[Any, Nothing, LifecyclePolicy] =
      ZIO.succeed(lifecyclePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest
  ) extends zio.aws.mediastore.model.PutLifecyclePolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
    override val lifecyclePolicy: LifecyclePolicy =
      zio.aws.mediastore.model.primitives
        .LifecyclePolicy(impl.lifecyclePolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.PutLifecyclePolicyRequest
  ): zio.aws.mediastore.model.PutLifecyclePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
