package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class GetMetricPolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest = {
    import GetMetricPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.GetMetricPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.GetMetricPolicyRequest.wrap(buildAwsValue())
}
object GetMetricPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.GetMetricPolicyRequest =
      zio.aws.mediastore.model.GetMetricPolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest
  ) extends zio.aws.mediastore.model.GetMetricPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.GetMetricPolicyRequest
  ): zio.aws.mediastore.model.GetMetricPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
