package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricPolicy(
    containerLevelMetrics: zio.aws.mediastore.model.ContainerLevelMetrics,
    metricPolicyRules: Option[
      Iterable[zio.aws.mediastore.model.MetricPolicyRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.MetricPolicy = {
    import MetricPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.MetricPolicy
      .builder()
      .containerLevelMetrics(containerLevelMetrics.unwrap)
      .optionallyWith(
        metricPolicyRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricPolicyRules)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.MetricPolicy.ReadOnly =
    zio.aws.mediastore.model.MetricPolicy.wrap(buildAwsValue())
}
object MetricPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.MetricPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.MetricPolicy =
      zio.aws.mediastore.model.MetricPolicy(
        containerLevelMetrics,
        metricPolicyRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerLevelMetrics: zio.aws.mediastore.model.ContainerLevelMetrics
    def metricPolicyRules
        : Option[List[zio.aws.mediastore.model.MetricPolicyRule.ReadOnly]]
    def getContainerLevelMetrics
        : ZIO[Any, Nothing, zio.aws.mediastore.model.ContainerLevelMetrics] =
      ZIO.succeed(containerLevelMetrics)
    def getMetricPolicyRules: ZIO[Any, AwsError, List[
      zio.aws.mediastore.model.MetricPolicyRule.ReadOnly
    ]] = AwsError.unwrapOptionField("metricPolicyRules", metricPolicyRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.MetricPolicy
  ) extends zio.aws.mediastore.model.MetricPolicy.ReadOnly {
    override val containerLevelMetrics
        : zio.aws.mediastore.model.ContainerLevelMetrics =
      zio.aws.mediastore.model.ContainerLevelMetrics
        .wrap(impl.containerLevelMetrics())
    override val metricPolicyRules
        : Option[List[zio.aws.mediastore.model.MetricPolicyRule.ReadOnly]] =
      scala
        .Option(impl.metricPolicyRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediastore.model.MetricPolicyRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.MetricPolicy
  ): zio.aws.mediastore.model.MetricPolicy.ReadOnly = new Wrapper(impl)
}
