package zio.aws.mediastore.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastore.model.primitives.{ContainerListLimit, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class ListContainersRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ContainerListLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.ListContainersRequest = {
    import ListContainersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.ListContainersRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ContainerListLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.ListContainersRequest.ReadOnly =
    zio.aws.mediastore.model.ListContainersRequest.wrap(buildAwsValue())
}
object ListContainersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.ListContainersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.ListContainersRequest =
      zio.aws.mediastore.model.ListContainersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ContainerListLimit]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ContainerListLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.ListContainersRequest
  ) extends zio.aws.mediastore.model.ListContainersRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediastore.model.primitives.PaginationToken(value))
    override val maxResults: Option[ContainerListLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.mediastore.model.primitives.ContainerListLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.ListContainersRequest
  ): zio.aws.mediastore.model.ListContainersRequest.ReadOnly = new Wrapper(impl)
}
