package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerPolicy
import scala.jdk.CollectionConverters.*
final case class GetContainerPolicyResponse(policy: ContainerPolicy) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse = {
    import GetContainerPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse
      .builder()
      .policy(ContainerPolicy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly =
    zio.aws.mediastore.model.GetContainerPolicyResponse.wrap(buildAwsValue())
}
object GetContainerPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.GetContainerPolicyResponse =
      zio.aws.mediastore.model.GetContainerPolicyResponse(policy)
    def policy: ContainerPolicy
    def getPolicy: ZIO[Any, Nothing, ContainerPolicy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse
  ) extends zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly {
    override val policy: ContainerPolicy =
      zio.aws.mediastore.model.primitives.ContainerPolicy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.GetContainerPolicyResponse
  ): zio.aws.mediastore.model.GetContainerPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
