package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class DeleteContainerPolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest = {
    import DeleteContainerPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediastore.model.DeleteContainerPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.DeleteContainerPolicyRequest.wrap(buildAwsValue())
}
object DeleteContainerPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DeleteContainerPolicyRequest =
      zio.aws.mediastore.model.DeleteContainerPolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest
  ) extends zio.aws.mediastore.model.DeleteContainerPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteContainerPolicyRequest
  ): zio.aws.mediastore.model.DeleteContainerPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
