package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateContainerResponse(
    container: zio.aws.mediastore.model.Container
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.CreateContainerResponse = {
    import CreateContainerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.CreateContainerResponse
      .builder()
      .container(container.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.CreateContainerResponse.ReadOnly =
    zio.aws.mediastore.model.CreateContainerResponse.wrap(buildAwsValue())
}
object CreateContainerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.CreateContainerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.CreateContainerResponse =
      zio.aws.mediastore.model.CreateContainerResponse(container.asEditable)
    def container: zio.aws.mediastore.model.Container.ReadOnly
    def getContainer
        : ZIO[Any, Nothing, zio.aws.mediastore.model.Container.ReadOnly] =
      ZIO.succeed(container)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.CreateContainerResponse
  ) extends zio.aws.mediastore.model.CreateContainerResponse.ReadOnly {
    override val container: zio.aws.mediastore.model.Container.ReadOnly =
      zio.aws.mediastore.model.Container.wrap(impl.container())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.CreateContainerResponse
  ): zio.aws.mediastore.model.CreateContainerResponse.ReadOnly = new Wrapper(
    impl
  )
}
