package zio.aws.mediastore.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerLevelMetrics {
  def unwrap
      : software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics
}
object ContainerLevelMetrics {
  def wrap(
      value: software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics
  ): zio.aws.mediastore.model.ContainerLevelMetrics = value match {
    case software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediastore.model.ContainerLevelMetrics {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics =
      software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.mediastore.model.ContainerLevelMetrics {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics =
      software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics.ENABLED
  }
  case object DISABLED extends zio.aws.mediastore.model.ContainerLevelMetrics {
    override def unwrap
        : software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics =
      software.amazon.awssdk.services.mediastore.model.ContainerLevelMetrics.DISABLED
  }
}
