package zio.aws.mediastore
import zio.prelude.Subtype
import zio.aws.mediastore.model.primitives.{TagKey, Origin, Header}
import java.time.Instant
import zio.aws.mediastore.model.primitives.ObjectGroup.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ContainerARN extends Subtype[String]
    type ContainerARN = zio.aws.mediastore.model.primitives.ContainerARN.Type
    object ContainerAccessLoggingEnabled extends Subtype[Boolean]
    type ContainerAccessLoggingEnabled =
      zio.aws.mediastore.model.primitives.ContainerAccessLoggingEnabled.Type
    object ContainerListLimit extends Subtype[Int]
    type ContainerListLimit =
      zio.aws.mediastore.model.primitives.ContainerListLimit.Type
    object ContainerName extends Subtype[String]
    type ContainerName = zio.aws.mediastore.model.primitives.ContainerName.Type
    object ContainerPolicy extends Subtype[String]
    type ContainerPolicy =
      zio.aws.mediastore.model.primitives.ContainerPolicy.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.mediastore.model.primitives.Endpoint.Type
    object Header extends Subtype[String]
    type Header = zio.aws.mediastore.model.primitives.Header.Type
    object LifecyclePolicy extends Subtype[String]
    type LifecyclePolicy =
      zio.aws.mediastore.model.primitives.LifecyclePolicy.Type
    object MaxAgeSeconds extends Subtype[Int]
    type MaxAgeSeconds = zio.aws.mediastore.model.primitives.MaxAgeSeconds.Type
    object ObjectGroup extends Subtype[String]
    type ObjectGroup = zio.aws.mediastore.model.primitives.ObjectGroup.Type
    object ObjectGroupName extends Subtype[String]
    type ObjectGroupName =
      zio.aws.mediastore.model.primitives.ObjectGroupName.Type
    object Origin extends Subtype[String]
    type Origin = zio.aws.mediastore.model.primitives.Origin.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.mediastore.model.primitives.PaginationToken.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.mediastore.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.mediastore.model.primitives.TagValue.Type
    object TimeStamp extends Subtype[Instant]
    type TimeStamp = zio.aws.mediastore.model.primitives.TimeStamp.Type
  }
  type AllowedHeaders = List[Header]
  type AllowedMethods = List[zio.aws.mediastore.model.MethodName]
  type AllowedOrigins = List[Origin]
  type ContainerList = List[zio.aws.mediastore.model.Container]
  type CorsPolicy = List[zio.aws.mediastore.model.CorsRule]
  type ExposeHeaders = List[Header]
  type MetricPolicyRules = List[zio.aws.mediastore.model.MetricPolicyRule]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.mediastore.model.Tag]
}
