package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeContainerResponse(
    container: Option[zio.aws.mediastore.model.Container] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse = {
    import DescribeContainerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse
      .builder()
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly =
    zio.aws.mediastore.model.DescribeContainerResponse.wrap(buildAwsValue())
}
object DescribeContainerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DescribeContainerResponse =
      zio.aws.mediastore.model
        .DescribeContainerResponse(container.map(value => value.asEditable))
    def container: Option[zio.aws.mediastore.model.Container.ReadOnly]
    def getContainer
        : ZIO[Any, AwsError, zio.aws.mediastore.model.Container.ReadOnly] =
      AwsError.unwrapOptionField("container", container)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse
  ) extends zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly {
    override val container
        : Option[zio.aws.mediastore.model.Container.ReadOnly] = scala
      .Option(impl.container())
      .map(value => zio.aws.mediastore.model.Container.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DescribeContainerResponse
  ): zio.aws.mediastore.model.DescribeContainerResponse.ReadOnly = new Wrapper(
    impl
  )
}
