package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class GetCorsPolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest = {
    import GetCorsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.GetCorsPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.GetCorsPolicyRequest.wrap(buildAwsValue())
}
object GetCorsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.GetCorsPolicyRequest =
      zio.aws.mediastore.model.GetCorsPolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest
  ) extends zio.aws.mediastore.model.GetCorsPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.GetCorsPolicyRequest
  ): zio.aws.mediastore.model.GetCorsPolicyRequest.ReadOnly = new Wrapper(impl)
}
