package zio.aws.mediastore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.mediastore.model.primitives.ContainerName
import scala.jdk.CollectionConverters.*
final case class DeleteMetricPolicyRequest(containerName: ContainerName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest = {
    import DeleteMetricPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest
      .builder()
      .containerName(ContainerName.unwrap(containerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.DeleteMetricPolicyRequest.ReadOnly =
    zio.aws.mediastore.model.DeleteMetricPolicyRequest.wrap(buildAwsValue())
}
object DeleteMetricPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.DeleteMetricPolicyRequest =
      zio.aws.mediastore.model.DeleteMetricPolicyRequest(containerName)
    def containerName: ContainerName
    def getContainerName: ZIO[Any, Nothing, ContainerName] =
      ZIO.succeed(containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest
  ) extends zio.aws.mediastore.model.DeleteMetricPolicyRequest.ReadOnly {
    override val containerName: ContainerName =
      zio.aws.mediastore.model.primitives.ContainerName(impl.containerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.DeleteMetricPolicyRequest
  ): zio.aws.mediastore.model.DeleteMetricPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
