package zio.aws.mediastore.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediastore.model.primitives.{MaxAgeSeconds, Header, Origin}
import scala.jdk.CollectionConverters.*
final case class CorsRule(
    allowedOrigins: Iterable[Origin],
    allowedMethods: Option[Iterable[zio.aws.mediastore.model.MethodName]] =
      None,
    allowedHeaders: Iterable[Header],
    maxAgeSeconds: Option[MaxAgeSeconds] = None,
    exposeHeaders: Option[Iterable[Header]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediastore.model.CorsRule = {
    import CorsRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediastore.model.CorsRule
      .builder()
      .allowedOrigins(allowedOrigins.map { item =>
        Origin.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        allowedMethods.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.allowedMethodsWithStrings)
      .allowedHeaders(allowedHeaders.map { item =>
        Header.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        maxAgeSeconds.map(value => MaxAgeSeconds.unwrap(value): Integer)
      )(_.maxAgeSeconds)
      .optionallyWith(
        exposeHeaders.map(value =>
          value.map { item =>
            Header.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exposeHeaders)
      .build()
  }
  def asReadOnly: zio.aws.mediastore.model.CorsRule.ReadOnly =
    zio.aws.mediastore.model.CorsRule.wrap(buildAwsValue())
}
object CorsRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediastore.model.CorsRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediastore.model.CorsRule =
      zio.aws.mediastore.model.CorsRule(
        allowedOrigins,
        allowedMethods.map(value => value),
        allowedHeaders,
        maxAgeSeconds.map(value => value),
        exposeHeaders.map(value => value)
      )
    def allowedOrigins: List[Origin]
    def allowedMethods: Option[List[zio.aws.mediastore.model.MethodName]]
    def allowedHeaders: List[Header]
    def maxAgeSeconds: Option[MaxAgeSeconds]
    def exposeHeaders: Option[List[Header]]
    def getAllowedOrigins: ZIO[Any, Nothing, List[Origin]] =
      ZIO.succeed(allowedOrigins)
    def getAllowedMethods
        : ZIO[Any, AwsError, List[zio.aws.mediastore.model.MethodName]] =
      AwsError.unwrapOptionField("allowedMethods", allowedMethods)
    def getAllowedHeaders: ZIO[Any, Nothing, List[Header]] =
      ZIO.succeed(allowedHeaders)
    def getMaxAgeSeconds: ZIO[Any, AwsError, MaxAgeSeconds] =
      AwsError.unwrapOptionField("maxAgeSeconds", maxAgeSeconds)
    def getExposeHeaders: ZIO[Any, AwsError, List[Header]] =
      AwsError.unwrapOptionField("exposeHeaders", exposeHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediastore.model.CorsRule
  ) extends zio.aws.mediastore.model.CorsRule.ReadOnly {
    override val allowedOrigins: List[Origin] = impl
      .allowedOrigins()
      .asScala
      .map { item =>
        zio.aws.mediastore.model.primitives.Origin(item)
      }
      .toList
    override val allowedMethods
        : Option[List[zio.aws.mediastore.model.MethodName]] = scala
      .Option(impl.allowedMethods())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediastore.model.MethodName.wrap(item)
        }.toList
      )
    override val allowedHeaders: List[Header] = impl
      .allowedHeaders()
      .asScala
      .map { item =>
        zio.aws.mediastore.model.primitives.Header(item)
      }
      .toList
    override val maxAgeSeconds: Option[MaxAgeSeconds] = scala
      .Option(impl.maxAgeSeconds())
      .map(value => zio.aws.mediastore.model.primitives.MaxAgeSeconds(value))
    override val exposeHeaders: Option[List[Header]] = scala
      .Option(impl.exposeHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediastore.model.primitives.Header(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediastore.model.CorsRule
  ): zio.aws.mediastore.model.CorsRule.ReadOnly = new Wrapper(impl)
}
