package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SpekeKeyProvider(
    encryptionContractConfiguration: Optional[
      zio.aws.mediapackagevod.model.EncryptionContractConfiguration
    ] = Optional.Absent,
    roleArn: __string,
    systemIds: Iterable[__string],
    url: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider = {
    import SpekeKeyProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
      .builder()
      .optionallyWith(
        encryptionContractConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionContractConfiguration)
      .roleArn(roleArn: java.lang.String)
      .systemIds(systemIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .url(url: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly =
    zio.aws.mediapackagevod.model.SpekeKeyProvider.wrap(buildAwsValue())
}
object SpekeKeyProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.SpekeKeyProvider =
      zio.aws.mediapackagevod.model.SpekeKeyProvider(
        encryptionContractConfiguration.map(value => value.asEditable),
        roleArn,
        systemIds,
        url
      )
    def encryptionContractConfiguration: Optional[
      zio.aws.mediapackagevod.model.EncryptionContractConfiguration.ReadOnly
    ]
    def roleArn: __string
    def systemIds: List[__string]
    def url: __string
    def getEncryptionContractConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.EncryptionContractConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionContractConfiguration",
      encryptionContractConfiguration
    )
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getSystemIds: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(systemIds)
    def getUrl: ZIO[Any, Nothing, __string] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
  ) extends zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly {
    override val encryptionContractConfiguration: Optional[
      zio.aws.mediapackagevod.model.EncryptionContractConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionContractConfiguration())
      .map(value =>
        zio.aws.mediapackagevod.model.EncryptionContractConfiguration
          .wrap(value)
      )
    override val roleArn: __string = impl.roleArn(): __string
    override val systemIds: List[__string] = impl
      .systemIds()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val url: __string = impl.url(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.SpekeKeyProvider
  ): zio.aws.mediapackagevod.model.SpekeKeyProvider.ReadOnly = new Wrapper(impl)
}
