package zio.aws.mediapackagevod.model
import scala.jdk.CollectionConverters.*
sealed trait SegmentTemplateFormat {
  def unwrap: software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat
}
object SegmentTemplateFormat {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat
  ): zio.aws.mediapackagevod.model.SegmentTemplateFormat = value match {
    case software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.NUMBER_WITH_TIMELINE =>
      val r = NUMBER_WITH_TIMELINE
      r
    case software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.TIME_WITH_TIMELINE =>
      val r = TIME_WITH_TIMELINE
      r
    case software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.NUMBER_WITH_DURATION =>
      val r = NUMBER_WITH_DURATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagevod.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object NUMBER_WITH_TIMELINE
      extends zio.aws.mediapackagevod.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.NUMBER_WITH_TIMELINE
  }
  case object TIME_WITH_TIMELINE
      extends zio.aws.mediapackagevod.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.TIME_WITH_TIMELINE
  }
  case object NUMBER_WITH_DURATION
      extends zio.aws.mediapackagevod.model.SegmentTemplateFormat {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat =
      software.amazon.awssdk.services.mediapackagevod.model.SegmentTemplateFormat.NUMBER_WITH_DURATION
  }
}
