package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePackagingConfigurationResponse(
    arn: Optional[__string] = Optional.Absent,
    cmafPackage: Optional[zio.aws.mediapackagevod.model.CmafPackage] =
      Optional.Absent,
    createdAt: Optional[__string] = Optional.Absent,
    dashPackage: Optional[zio.aws.mediapackagevod.model.DashPackage] =
      Optional.Absent,
    hlsPackage: Optional[zio.aws.mediapackagevod.model.HlsPackage] =
      Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    mssPackage: Optional[zio.aws.mediapackagevod.model.MssPackage] =
      Optional.Absent,
    packagingGroupId: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse = {
    import CreatePackagingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(cmafPackage.map(value => value.buildAwsValue()))(
        _.cmafPackage
      )
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(dashPackage.map(value => value.buildAwsValue()))(
        _.dashPackage
      )
      .optionallyWith(hlsPackage.map(value => value.buildAwsValue()))(
        _.hlsPackage
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(mssPackage.map(value => value.buildAwsValue()))(
        _.mssPackage
      )
      .optionallyWith(packagingGroupId.map(value => value: java.lang.String))(
        _.packagingGroupId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly =
    zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse
      .wrap(buildAwsValue())
}
object CreatePackagingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse =
      zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse(
        arn.map(value => value),
        cmafPackage.map(value => value.asEditable),
        createdAt.map(value => value),
        dashPackage.map(value => value.asEditable),
        hlsPackage.map(value => value.asEditable),
        id.map(value => value),
        mssPackage.map(value => value.asEditable),
        packagingGroupId.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def cmafPackage
        : Optional[zio.aws.mediapackagevod.model.CmafPackage.ReadOnly]
    def createdAt: Optional[__string]
    def dashPackage
        : Optional[zio.aws.mediapackagevod.model.DashPackage.ReadOnly]
    def hlsPackage: Optional[zio.aws.mediapackagevod.model.HlsPackage.ReadOnly]
    def id: Optional[__string]
    def mssPackage: Optional[zio.aws.mediapackagevod.model.MssPackage.ReadOnly]
    def packagingGroupId: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCmafPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.CmafPackage.ReadOnly
    ] = AwsError.unwrapOptionField("cmafPackage", cmafPackage)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDashPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.DashPackage.ReadOnly
    ] = AwsError.unwrapOptionField("dashPackage", dashPackage)
    def getHlsPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.HlsPackage.ReadOnly
    ] = AwsError.unwrapOptionField("hlsPackage", hlsPackage)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMssPackage: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagevod.model.MssPackage.ReadOnly
    ] = AwsError.unwrapOptionField("mssPackage", mssPackage)
    def getPackagingGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("packagingGroupId", packagingGroupId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse
  ) extends zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val cmafPackage
        : Optional[zio.aws.mediapackagevod.model.CmafPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cmafPackage())
        .map(value => zio.aws.mediapackagevod.model.CmafPackage.wrap(value))
    override val createdAt: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __string)
    override val dashPackage
        : Optional[zio.aws.mediapackagevod.model.DashPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashPackage())
        .map(value => zio.aws.mediapackagevod.model.DashPackage.wrap(value))
    override val hlsPackage
        : Optional[zio.aws.mediapackagevod.model.HlsPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hlsPackage())
        .map(value => zio.aws.mediapackagevod.model.HlsPackage.wrap(value))
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val mssPackage
        : Optional[zio.aws.mediapackagevod.model.MssPackage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mssPackage())
        .map(value => zio.aws.mediapackagevod.model.MssPackage.wrap(value))
    override val packagingGroupId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.packagingGroupId())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreatePackagingConfigurationResponse
  ): zio.aws.mediapackagevod.model.CreatePackagingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
