package zio.aws.mediapackagevod.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.mediapackagevod.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAssetResponse(
    arn: Optional[__string] = Optional.Absent,
    createdAt: Optional[__string] = Optional.Absent,
    egressEndpoints: Optional[
      Iterable[zio.aws.mediapackagevod.model.EgressEndpoint]
    ] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    packagingGroupId: Optional[__string] = Optional.Absent,
    resourceId: Optional[__string] = Optional.Absent,
    sourceArn: Optional[__string] = Optional.Absent,
    sourceRoleArn: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse = {
    import CreateAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(
        egressEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.egressEndpoints)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(packagingGroupId.map(value => value: java.lang.String))(
        _.packagingGroupId
      )
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(sourceArn.map(value => value: java.lang.String))(
        _.sourceArn
      )
      .optionallyWith(sourceRoleArn.map(value => value: java.lang.String))(
        _.sourceRoleArn
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly =
    zio.aws.mediapackagevod.model.CreateAssetResponse.wrap(buildAwsValue())
}
object CreateAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagevod.model.CreateAssetResponse =
      zio.aws.mediapackagevod.model.CreateAssetResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        egressEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value => value),
        packagingGroupId.map(value => value),
        resourceId.map(value => value),
        sourceArn.map(value => value),
        sourceRoleArn.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def createdAt: Optional[__string]
    def egressEndpoints
        : Optional[List[zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly]]
    def id: Optional[__string]
    def packagingGroupId: Optional[__string]
    def resourceId: Optional[__string]
    def sourceArn: Optional[__string]
    def sourceRoleArn: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEgressEndpoints: ZIO[Any, AwsError, List[
      zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("egressEndpoints", egressEndpoints)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getPackagingGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("packagingGroupId", packagingGroupId)
    def getResourceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getSourceArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getSourceRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceRoleArn", sourceRoleArn)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse
  ) extends zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val createdAt: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __string)
    override val egressEndpoints: Optional[
      List[zio.aws.mediapackagevod.model.EgressEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.egressEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagevod.model.EgressEndpoint.wrap(item)
        }.toList
      )
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val packagingGroupId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.packagingGroupId())
      .map(value => value: __string)
    override val resourceId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: __string)
    override val sourceArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => value: __string)
    override val sourceRoleArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRoleArn())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagevod.model.CreateAssetResponse
  ): zio.aws.mediapackagevod.model.CreateAssetResponse.ReadOnly = new Wrapper(
    impl
  )
}
